unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jpeg, ExtCtrls, ZLib;

type
  TForm4 = class(TForm)
    Image1: TImage;
    GroupBox5: TGroupBox;
    ListBox1: TListBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Button5: TButton;
    Button4: TButton;
    Button2: TButton;
    Button3: TButton;
    Button1: TButton;
    GroupBox4: TGroupBox;
    Button6: TButton;
    Button7: TButton;
    GroupBox1: TGroupBox;
    Memo1: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button8: TButton;
    ComboBox2: TComboBox;
    ComboBox1: TComboBox;
    Edit2: TEdit;
    Edit1: TEdit;
    Memo2: TMemo;
    Memo3: TMemo;
    Memo4: TMemo;
    procedure Button7Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure LoadAllTests();
    procedure ReadAndLoadTest();
    procedure LoadInList();
    procedure NextQuest(ind:Integer);
    procedure SelectQuest();
    procedure QuestEnd();
    procedure SaveReport(j:Byte);
    procedure SaveToStream(str:String);
    procedure OpenFromStream(str:string);
    procedure Button8Click(Sender: TObject);
    procedure ComboBox1Select(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form4: TForm4;

  mydir,StudentName,group,theme,TestName:string;

  QuestPos:array of integer;
  QuestAnswer,StudentAnswer:array of Char;

  CurrentQuest,GoodAnswer:integer;

implementation

uses Unit1, Unit5;

{$R *.dfm}

procedure TForm4.Button7Click(Sender: TObject);
begin
Form4.Close;
Form1.Show;
end;

procedure TForm4.FormClose(Sender: TObject; var Action: TCloseAction);
begin

//ListBox1.Clear;
//Memo1.Clear;

//Edit1.Clear;
//Edit2.Clear;

//ComboBox1.Clear;
//ComboBox2.Clear;

 Memo1.Clear;
 Memo2.Clear;
 Memo3.Clear;
 Memo4.Clear;
 
 ListBox1.Items.Clear;
 
 StudentName:='';
 group:='';
 theme:='';
 TestName:='';

 Edit1.Text:='';
 Edit2.Text:='';

 ComboBox1.ItemIndex:=0;
 ComboBox2.ItemIndex:=0;

 GoodAnswer:=0;
 CurrentQuest:=0;

 QuestPos:=nil;
 QuestAnswer:=nil;
 StudentAnswer:=nil;

 Action:=caFree;

end;

procedure TForm4.Button8Click(Sender: TObject);
begin
  if (Edit1.Text<>'') and (Edit2.Text<>'') and (ComboBox1.Text<>'  :') and (ComboBox2.Text<>'  :') then
  begin
    StudentName:=Edit1.Text;
    group:=Edit2.Text;
    theme:=ComboBox1.Items[ComboBox1.itemindex];
    testname:=ComboBox2.Items[ComboBox2.itemindex];
    Panel1.Visible:=false;
    OpenFromStream(mydir+theme+'\\'+testname);
    Button6.Enabled:=true;
    ReadAndLoadTest();
  end
  else ShowMessage('  !');
end;

procedure TForm4.LoadAllTests;
var
   papki:TSearchRec;
begin
    if FindFirst(Mydir+'*', faDirectory, papki) = 0 then
     begin
      repeat
        if (papki.attr and faDirectory) = faDirectory then
        begin
          if (papki.name<>'.') and (papki.name<>'..')then
          begin
            ComboBox1.Items.Add(papki.name);
          end;
        end;
      until FindNext(papki) <> 0;

     //  
     FindClose(papki);
     end;
end;

procedure TForm4.ComboBox1Select(Sender: TObject);
var
papki:TSearchRec;
begin
    if FindFirst(Mydir+ComboBox1.Items[ComboBox1.itemindex]+'\\*.test', faDirectory, papki) = 0 then
     begin
      repeat
          if (papki.name<>'.') and (papki.name<>'..')then
          begin
            ComboBox2.Items.Add(papki.name);
          end;
      until FindNext(papki) <> 0;

     //  
     FindClose(papki);
     end;
end;

procedure TForm4.ReadAndLoadTest;
var
  i:Integer;
  str:string;
begin
  for i:=0 to Memo2.Lines.Count-1 do
  begin
    if (Memo2.Lines[i]='---') then
    begin
      SetLength(QuestPos,Length(QuestPos)+1);
      QuestPos[Length(QuestPos)-1]:=i;
    end;
    str:=Memo2.Lines[i];
    if (str<>'') and (str[1]='`') then
    begin
      SetLength(QuestAnswer,Length(QuestAnswer)+1);
      QuestAnswer[Length(QuestAnswer)-1]:=str[2];
      Delete(str,1,1);
      Memo2.Lines[i]:=str;
      SetLength(StudentAnswer,Length(QuestAnswer));
    end;
  end;
  LoadInList();
end;

procedure TForm4.LoadInList;
var
  i:Integer;
begin
  for i:=0 to Length(QuestPos)-2 do
  begin
  ListBox1.Items.Add(' '+inttostr(i+1));
  end;
  NextQuest(0);
end;

procedure TForm4.ListBox1Click(Sender: TObject);
begin
SelectQuest();
end;

procedure TForm4.NextQuest(ind: Integer);
begin
ListBox1.ItemIndex:=ind;
SelectQuest();
end;

procedure TForm4.SelectQuest;
var
  i:integer;
begin
  CurrentQuest:=ListBox1.ItemIndex;
  Memo1.Lines.Clear;
  for i:=QuestPos[CurrentQuest]+1 to QuestPos[ListBox1.ItemIndex+1]-1 do
  begin
    Memo1.Lines.Add(Memo2.Lines[i]);
  end;
end;

procedure TForm4.Button1Click(Sender: TObject);
begin
 StudentAnswer[CurrentQuest]:=TButton(Sender).Caption[1];
 ListBox1.Items[ListBox1.Itemindex]:=ListBox1.Items[ListBox1.Itemindex]+' (.)';
 if(CurrentQuest<>ListBox1.Items.Count-1) then NextQuest(CurrentQuest+1);
end;

procedure TForm4.Button3Click(Sender: TObject);
begin
 StudentAnswer[CurrentQuest]:=TButton(Sender).Caption[1];
 ListBox1.Items[ListBox1.Itemindex]:=ListBox1.Items[ListBox1.Itemindex]+' (.)';
 if(CurrentQuest<>ListBox1.Items.Count-1) then NextQuest(CurrentQuest+1);
end;

procedure TForm4.Button2Click(Sender: TObject);
begin
 StudentAnswer[CurrentQuest]:=TButton(Sender).Caption[1];
 ListBox1.Items[ListBox1.Itemindex]:=ListBox1.Items[ListBox1.Itemindex]+' (.)';
 if(CurrentQuest<>ListBox1.Items.Count-1) then NextQuest(CurrentQuest+1);
end;

procedure TForm4.Button4Click(Sender: TObject);
begin
 StudentAnswer[CurrentQuest]:=TButton(Sender).Caption[1];
 ListBox1.Items[ListBox1.Itemindex]:=ListBox1.Items[ListBox1.Itemindex]+' (.)';
 if(CurrentQuest<>ListBox1.Items.Count-1) then NextQuest(CurrentQuest+1);
end;

procedure TForm4.Button5Click(Sender: TObject);
begin
 StudentAnswer[CurrentQuest]:=TButton(Sender).Caption[1];
 ListBox1.Items[ListBox1.Itemindex]:=ListBox1.Items[ListBox1.Itemindex]+' (.)';
 if(CurrentQuest<>ListBox1.Items.Count-1) then NextQuest(CurrentQuest+1);
end;

procedure TForm4.Button6Click(Sender: TObject);
begin
QuestEnd();
end;

procedure TForm4.QuestEnd;
var
  i:integer;
  proc:real;
begin

Button6.Enabled:=false;

  Memo1.Lines.Clear;
  Memo4.Lines.Clear;
  Memo1.Lines.Add(' : ');
  Memo4.Lines.Add(' : ');
  Memo1.Lines.Add(', : '+StudentName);
  Memo4.Lines.Add(', : '+StudentName);
  Memo1.Lines.Add(' : '+group);
  Memo4.Lines.Add(' : '+group);
  Memo1.Lines.Add(' : '+theme);
  Memo4.Lines.Add(' : '+theme);
  Memo1.Lines.Add(': '+testname);
  Memo4.Lines.Add(': '+testname);
  Memo1.Lines.Add('/  : '+(DateToStr(Date)+', '+TimeToStr(Time)));
  Memo4.Lines.Add('/  : '+(DateToStr(Date)+', '+TimeToStr(Time)));

  Memo1.Lines.Add(' ');

  Memo1.Lines.Add('/: ');
  for i:=0 to Length(QuestAnswer)-1 do
  begin
   if (QuestAnswer[i]=StudentAnswer[i])then
     begin
       Memo1.Lines.Add(' '+IntToStr(i+1)+' -  ');
       GoodAnswer:=GoodAnswer+1;
     end
   else
     begin
       Memo1.Lines.Add(' '+IntToStr(i+1)+' -  ');
     end;
  end;

  Memo1.Lines.Add(' ');
  Memo4.Lines.Add(' ');

  Memo1.Lines.Add('   : ');
  Memo4.Lines.Add('   : ');

  Memo1.Lines.Add(' : '+IntToStr(Length(QuestAnswer)));
  Memo4.Lines.Add(' : '+IntToStr(Length(QuestAnswer)));

//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//

  proc:=Trunc(100/Length(QuestAnswer)*GoodAnswer);

//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//

  Memo1.Lines.Add(': '+IntToStr(GoodAnswer)+' ('+FloatToStr(proc)+'%)');
  Memo4.Lines.Add(': '+IntToStr(GoodAnswer)+' ('+FloatToStr(proc)+'%)');

  Memo1.Lines.Add(': '+IntToStr(Length(QuestAnswer)-GoodAnswer));
  Memo4.Lines.Add(': '+IntToStr(Length(QuestAnswer)-GoodAnswer));

//----------------------------------------------------------------------------//

  Memo1.Lines.Add(' ');
  Memo4.Lines.Add(' ');
  Memo1.Lines.Add(' : ');
  Memo4.Lines.Add(' : ');

//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//

//----------------------------------------------------------------------------//
    if (proc>=95) and (proc<=100) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : A');
      Memo4.Lines.Add(' : A');
      Memo1.Lines.Add(' : 4,0');
      Memo4.Lines.Add(' : 4,0');
  end;
    if (proc>=90) and (proc<=94) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : A-');
      Memo4.Lines.Add(' : A-');
      Memo1.Lines.Add(' : 3,67');
      Memo4.Lines.Add(' : 3,67');
  end;
//----------------------------------------------------------------------------//
    if (proc>=85) and (proc<=89) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : B+');
      Memo4.Lines.Add(' : B+');
      Memo1.Lines.Add(' : 3,33');
      Memo4.Lines.Add(' : 3,33');
  end;
    if (proc>=80) and (proc<=84) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : B');
      Memo4.Lines.Add(' : B');
      Memo1.Lines.Add(' : 3,0');
      Memo4.Lines.Add(' : 3,0');
  end;
    if (proc>=75) and (proc<=79) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : B-');
      Memo4.Lines.Add(' : B-');
      Memo1.Lines.Add(' : 2,67');
      Memo4.Lines.Add(' : 2,67');
  end;
//----------------------------------------------------------------------------//
    if (proc>=70) and (proc<=74) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : C+');
      Memo4.Lines.Add(' : C+');
      Memo1.Lines.Add(' : 2,33');
      Memo4.Lines.Add(' : 3,33');
  end;
    if (proc>=65) and (proc<=69) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : C');
      Memo4.Lines.Add(' : C');
      Memo1.Lines.Add(' : 2,0');
      Memo4.Lines.Add(' : 2,0');
  end;
    if (proc>=60) and (proc<=64) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : C-');
      Memo4.Lines.Add(' : C-');
      Memo1.Lines.Add(' : 1,67');
      Memo4.Lines.Add(' : 1,67');
  end;
    if (proc>=55) and (proc<=59) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : D+');
      Memo4.Lines.Add(' : D+');
      Memo1.Lines.Add(' : 1,33');
      Memo4.Lines.Add(' : 1,33');
  end;
    if (proc>=50) and (proc<=54) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : D');
      Memo4.Lines.Add(' : D');
      Memo1.Lines.Add(' : 1,0');
      Memo4.Lines.Add(' : 1,0');
  end;
//----------------------------------------------------------------------------//
    if (proc<=49) then
  begin
      Memo1.Lines.Add(': ');
      Memo4.Lines.Add(': ');
      Memo1.Lines.Add(' : F');
      Memo4.Lines.Add(' : F');
      Memo1.Lines.Add(' : 0');
      Memo4.Lines.Add(' : 0');
  end;
//----------------------------------------------------------------------------//

//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//

  SaveReport(0);

end;

procedure TForm4.SaveReport(j: Byte);
begin
  if FileExists(Mydir+theme+'\\'+StudentName+', '+group+', '+' ('+IntToStr(j)+') '+'.txt') then
   begin
     j:=j+1;
     SaveReport(j);
   end
  else Memo4.Lines.SaveToFile(Mydir+theme+'\\'+StudentName+', '+group+', '+' (' +IntToStr(j)+ ') '+'.txt');
end;

procedure TForm4.SaveToStream(str: String);
var
  AStream : TFileStream;
  AZLib : TCompressionStream;
  AMemStream : TMemoryStream;
  ALen : Int64;
begin
  AStream := TFileStream.Create(str,fmCreate);
  AMemStream := TMemoryStream.Create;
  AZLib := TCompressionStream.Create(clMax,AStream);
  Try
    Memo3.Lines.SaveToStream(AMemStream);
    AMemStream.Seek(0,0);
    ALen := AMemStream.Size;
    AZLib.WriteBuffer(ALen,SizeOf(Int64));
    AZLib.CopyFrom(AMemStream,ALen);
  Finally
    AZLib.Free;
    AStream.Free;
  End;
end;

procedure TForm4.OpenFromStream(str: string);
var
  AZLib : TDecompressionStream;
  AStream : TFileStream;
  AMemStream : TMemoryStream;
  ALen : Int64;
begin
  AStream := TFileStream.Create(str,fmOpenRead);
  AZLib := TDecompressionStream.Create(AStream);
  AMemStream := TMemoryStream.Create;
  Try
    AZLib.ReadBuffer(ALen,SizeOf(Int64));
    AMemStream.CopyFrom(AZLib,ALen);
    AMemStream.Seek(0,0);
    Memo2.Lines.LoadFromStream(AMemStream);
  Finally
    AMemStream.Free;
    AZLib.Free;
    AStream.Free;
  End;
end;

procedure TForm4.FormActivate(Sender: TObject);
begin

Panel1.Visible:=true;

end;

procedure TForm4.FormCreate(Sender: TObject);
begin
  mydir:=ExtractFilePath(ParamStr(0));
  mydir:=mydir+'\';
  GoodAnswer:=0;
  LoadAllTests();
end;

end.
